import 'package:flutter/material.dart';
import 'package:line_icons/line_icons.dart';

class ScrollToTopButton extends StatefulWidget {
  const ScrollToTopButton({
    super.key,
    required this.controller,
    this.outerController,
  });

  final ScrollController controller;
  final ScrollController? outerController;

  @override
  State<ScrollToTopButton> createState() => _ScrollToTopButtonState();
}

class _ScrollToTopButtonState extends State<ScrollToTopButton> {
  bool _showFab = false;

  @override
  void initState() {
    widget.controller.addListener(_scrollListener);
    super.initState();
  }

  void _scrollListener() {
    // Show FAB when scrolled past the screen size
    if (widget.controller.position.pixels >
        MediaQuery.of(context).size.height) {
      if (!_showFab) {
        setState(() {
          _showFab = true;
        });
      }
    } else {
      if (_showFab) {
        setState(() {
          _showFab = false;
        });
      }
    }
  }

  @override
  void dispose() {
    widget.controller.removeListener(_scrollListener);
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return _showFab
        ? FloatingActionButton.small(
            backgroundColor: Theme.of(context).primaryColor,
            child: const Icon(LineIcons.arrowUp, color: Colors.white),
            onPressed: () {
              // Scroll to the very top
              if (widget.controller.hasClients) {
                // Scroll inner controller to top
                widget.controller.animateTo(
                  0.0,
                  duration: const Duration(milliseconds: 400),
                  curve: Curves.easeOutCubic,
                );
              }
              // Also scroll outer controller if provided (for NestedScrollView)
              if (widget.outerController != null && widget.outerController!.hasClients) {
                widget.outerController!.animateTo(
                  0.0,
                  duration: const Duration(milliseconds: 400),
                  curve: Curves.easeOutCubic,
                );
              }
            },
          )
        : const SizedBox.shrink();
  }
}
